import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/pages/common/form_editor_page.dart';

class AzureSection extends StatefulWidget {
  const AzureSection({Key? key}) : super(key: key);

  @override
  _AzureSectionState createState() => _AzureSectionState();
}

class _AzureSectionState extends State<AzureSection> with AppActiveContentMixin {
  @override
  build(context) {
    return FormEditorPage(
      heading: 'Microsoft Azure Blob - Container Configuration',
      description: 'Below you can configure a Blob Container which can be used for storing uploaded media.',
      items: [
        SettingItem(
          intId: AppSettings.ID_SS_TEXT_AZURE_BLOB_CONTAINER,
          settingKey: AppSettings.KEY_SS_TEXT_AZURE_BLOB_CONTAINER,
          type: FieldType.text,
          leading: 'Container Name',
          description: 'Name of Azure Blob Container.',
        ),
        SettingItem(
          intId: AppSettings.ID_SS_TEXT_AZURE_BLOB_DSN,
          settingKey: AppSettings.KEY_SS_TEXT_AZURE_BLOB_DSN,
          type: FieldType.text,
          leading: 'Azure DSN',
          description: 'Azure Data Source Name(DSN - connection string) will be used to connect to your azure account.',
        ),
      ],
    );
  }
}
